from pytest_bdd import scenario, given, when, then, parsers

import contacts

from .steps import *

@scenario("features/list_contacts.feature", 
            "Wyświetlenie listy dodanych wpisów książki adresowej")
def test_listing_added_contacts(capsys):
    pass


@given("Mam pierwszy wpis <first>")
def have_a_first_contact(contactbook, first):
    contactbook.add(first, "000")
    return first


@given("Mam drugi wpis <second>")
def have_a_second_contact(contactbook, second):
    contactbook.add(second, "000")
    return second


@then("Dane wyjściowe zawierają listę wpisów <listed_contacts>")
def outputcontains(listed_contacts, capsys):
    expected_list = "".join([f"{c} 000\n" for c in listed_contacts.split(",")])
    out, _ = capsys.readouterr()
    assert out == expected_list
